--Loadouts database
-------------------------------------------------------------------------------------------------------

--[[ Loadout Entry Example ----------------------------------------------------------------------------

["MiG-21Bis"] = {														--String, aircraft type
	["Strike"] = {														--String, task
		["Custom Loadout Name"] = {										--String, custom loadout name
			support = {													--Table, list of tasks that can support this loadout (nil = is never added, true = is added when available)
				["Escort"] = true,										--Fighter escort
				["SEAD"] = true,										--SEAD	escort
				["Escort Jammer"] = true,								--Jammer escort
				["Flare Illumination"] = true,							--Target area flare illumination (mandatory support for loadout to be eligible)
				["Laser Illumination"] = true,							--Target laser illumination (mandatory support for loadout to be eligible)
			},
			attributes = {												--Array, custom loadout attributes. Only used by A-G tasks. Any target attribute must be matched in this array for the loadout to be eligible for the target.
				[1] = "Anti-tank",										--String, custom attribute to be matched for target attribute
				[2] = "Stand-off Missile",								--String, custom attribute to be matched for target attribute
			},
			weaponType = "Bombs",										--String, type of ordinance of loadout. Only used by A-G taks. Options: "Cannon", "Rockets", "Bombs", "Guided bombs", "ASM". A-G weapon types cannot be mixed.
			expend = "All",												--String, quantity of wapons expended per attack. Only used by A-G tasks. Options: "Auto", "All", "Half", "Two".
			day = true,													--Boolean, loadout is day capable
			night = false,												--Boolean, loadout is night capable
			adverseWeather = false,										--Boolean, loadout is adverse weather capable
			range = 900000,												--Number, range radius in meters
			capability = 10,											--Number, how good is the aircraft with this loadout. The higher the better
			firepower = 10,												--Number, how much firepower has this loadout. The higher the better
			vCruise = 225,												--Number, cruise speed in m/s
			vAttack = 280,												--Number, attack speed in m/s
			hCruise = 6000,												--Number, cruise altitude in m
			hAttack = 100,												--Number, attack altitude in m
			standoff = 5000,											--Number, attack distance from target in m. Determines attack waypoint distance for A-G with missiles (for Bombss use nil) and engage distance for A-A tasks
			tStation = 1200,											--Number, seconds the aircraft can remain on station. Only used by CAP, AWACS and Refuelling tasks
			LDSD = false,												--Boolean, aircraft is Look-Down/Shoot-Down capable. Only used by CAP and Intercept tasks
			self_escort = false,										--Boolean, aircraft can defend itself against fighters. Only used by A-G tasks
			sortie_rate = 6,											--Number, average amount of sorties that aircraft flies per day
			stores = {													--Table, loadout table for DCS
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{R-60M 2L}",
					},
					[2] = 
					{
						["CLSID"] = "{R-3R}",
					},
					[3] = 
					{
						["CLSID"] = "{PTB_800_MIG21}",
					},
					[4] = 
					{
						["CLSID"] = "{R-3R}",
					},
					[5] = 
					{
						["CLSID"] = "{R-60M 2R}",
					},
					[6] = 
					{
						["CLSID"] = "{ASO-2}",
					},
				},
				["fuel"] = 2280,
				["flare"] = 32,
				["ammo_type"] = 1,
				["chaff"] = 32,
				["gun"] = 100,
			},
		},
	},
},

]]-----------------------------------------------------------------------------------------------------


db_loadouts = {
	["MiG-19P"] = {
		["Intercept"] = {
			["Intercept IPW - Intercept - K-13A*2"] = {
				attributes = {},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 150000,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
			},
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
			-- ["Intercept  IPW K-13A*2, PTB-760*2"] = {
				-- attributes = {},
				-- weaponType = nil,
				-- expend = nil,
				-- day = true,
				-- night = false,
				-- adverseWeather = false,
				-- range = 250000,
				-- capability = 10,
				-- firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				-- LDSD = false,
				-- self_escort = true,
				-- sortie_rate = 6,
				-- stores = {
			-- ["pylons"] = {
				-- [6] = {
					-- ["CLSID"] = "{K-13A}",
					-- ["num"] = 6,
				-- },
				-- [1] = {
					-- ["CLSID"] = "{K-13A}",
					-- ["num"] = 1,
				-- },
				-- [5] = {
					-- ["CLSID"] = "PTB760_MIG19",
					-- ["num"] = 5,
				-- },
				-- [2] = {
					-- ["CLSID"] = "PTB760_MIG19",
					-- ["num"] = 2,
				-- },
			-- },
				-- ["fuel"] = "1800",
                -- ["flare"] = 0,
                -- ["chaff"] = 0,
                -- ["gun"] = 100,
				-- },
				-- ["AddPropAircraft"] = 
                                        -- {
                                            -- ["MissileToneVolume"] = 5,
                                            -- ["NAV_Initial_Hdg"] = 0,
                                            -- ["ADF_Selected_Frequency"] = 1,
                                            -- ["ADF_NEAR_Frequency"] = 303,
                                            -- ["ADF_FAR_Frequency"] = 625,
                                            -- ["MountSIRENA"] = true,
                                        -- }, -- end of ["AddPropAircraft"]
			-- },
		},
		["CAP"] = {
			["CAP IPW K-13A*2, PTB-760*2"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 6,
				firepower = 1,
				vCruise = 200,
				vAttack = 213.86666666667,
				hCruise = 7096,
				hAttack = 7096,
				standoff = 3000,
				tStation = 1800,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 2,
				},
			},
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},
		["Escort"] = {
			[" Escort IPW K-13A*2, PTB-760*2"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 5,
				firepower = 5,
				vCruise = 200,
				-- vAttack = 346.66666666667,
				-- hCruise = 7096,
				-- hAttack = 7096,
				standoff = 3000,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 2,
				},
			},
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},	
		["Fighter Sweep"] = {
			["Fighter Sweep TF-Old-LR-AIM-9M*2,AIM7MH*4,FT*3"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 5,
				firepower = 5,
				vCruise = 200,
				vAttack = 250,
				hCruise = 5000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 2,
				},
			},
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},	
		["Anti-ship Strike"] = {
			["IPW - Strike - K-13A*2, FAB-250*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 5000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		["Antiship IPW - Strike SR - K-13A*2, ORO-57K*4"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},			
		},	
		["Strike"] = {
			["IPW - Strike - K-13A*2, FAB-250*2"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
			["IPW - Strike SR - K-13A*2, ORO-57K*4"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1800",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
			-- ["IPW - Strike - K-13A*2, PTB-760*2, FAB-250*2"] = {
			-- minscore = 0.3,
				-- support = {
					-- ["Escort"] = true,
					-- ["SEAD"] = false,
				-- },
				-- attributes = {"soft", "Parked Aircraft", "Structure"},
				-- weaponType = "Bombs",
				-- expend = "All",
				-- attackType = "Dive",
				-- day = true,
				-- night = false,
				-- adverseWeather = false,
				-- range = 650000,
				-- capability = 1,
				-- firepower = 1,
				-- vCruise = 200,
				-- vAttack = 300.5,
				-- hCruise = 5486.4,
				-- hAttack = 4572,
				-- standoff = nil,
				-- tStation = nil,
				-- LDSD = false,
				-- - self_escort = true,
				-- sortie_rate = 6,
				-- stores = {
					-- ["pylons"] = {
				-- [6] = {
					-- ["CLSID"] = "{K-13A}",
					-- ["num"] = 6,
				-- },
				-- [1] = {
					-- ["CLSID"] = "{K-13A}",
					-- ["num"] = 1,
				-- },
				-- [5] = {
					-- ["CLSID"] = "PTB760_MIG19",
					-- ["num"] = 5,
				-- },
				-- [2] = {
					-- ["CLSID"] = "PTB760_MIG19",
					-- ["num"] = 2,
				-- },
				-- [5] = {
					-- ["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					-- ["num"] = 5,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					-- ["num"] = 2,
				-- },
			-- }, -- end of ["pylons"]
				-- ["fuel"] = "1800",
                -- ["flare"] = 0,
                -- ["chaff"] = 0,
                -- ["gun"] = 100,
				-- },
				-- ["AddPropAircraft"] = 
                                        -- {
                                            -- ["MissileToneVolume"] = 5,
                                            -- ["NAV_Initial_Hdg"] = 0,
                                            -- ["ADF_Selected_Frequency"] = 1,
                                            -- ["ADF_NEAR_Frequency"] = 303,
                                            -- ["ADF_FAR_Frequency"] = 625,
                                            -- ["MountSIRENA"] = true,
                                        -- }, -- end of ["AddPropAircraft"]
			-- },
			["IPW - Strike - K-13A*2, PTB-760*2, ORO-57K*2"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
				["fuel"] = 1800,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},
	},
	["F-86F Sabre"] = {
		["Intercept"] = {
			["Intercept IPW - 200gal Fuel*2, AIM-9*2"] = {
				attributes = {},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 150000,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			},
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["Intercept IPW - AIM-9*2"] = {
				attributes = {},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 250000,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			},
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["CAP IPW - 200gal Fuel*2, AIM-9*2"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 6,
				firepower = 1,
				vCruise = 180,
				vAttack = 200,
				hCruise = 7096,
				hAttack = 7096,
				-- standoff = 36000,
				tStation = 1800,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			},
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			[" Escort IPW - 200gal Fuel*2, AIM-9*2"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 5,
				firepower = 5,
				vCruise = 200,
				-- vAttack = 346.66666666667,
				-- hCruise = 7096,
				-- hAttack = 7096,
				standoff = 1000,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			},
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},	
		["Fighter Sweep"] = {
			["Fighter Sweep IPW - 200gal Fuel*2, AIM-9*2"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 450000,
				capability = 5,
				firepower = 5,
				vCruise = 200,
				vAttack = 250,
				hCruise = 5000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			},
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},	
		["Anti-ship Strike"] = {
			["IPW - Antiship Strike - 200gal Fuel*2, AIM-9*2, M117*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{00F5DAC4-0466-4122-998F-B1A298E34113}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{00F5DAC4-0466-4122-998F-B1A298E34113}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Antiship Strike - 200gal Fuel*2, AIM-9*2, AN-M64*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{F86ANM64}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{F86ANM64}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["Antiship IPW - Strike - AIM-9*2, HVAR*16"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 3,
				},
				[9] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["Antiship IPW - Strike - 200gal Fuel*2, AIM-9*2, HVAR*8"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 8,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},	
		},	
		["Strike"] = {
			["IPW - Strike - 200gal Fuel*2, AIM-9*2, M117*2"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{00F5DAC4-0466-4122-998F-B1A298E34113}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{00F5DAC4-0466-4122-998F-B1A298E34113}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Strike - 200gal Fuel*2, AIM-9*2, HVAR*8"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 8,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Strike - 200gal Fuel*2, AIM-9*2, AN-M64*2"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{F86ANM64}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{F86ANM64}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - IPW - Strike - AIM-9*2, HVAR*16"] = {
			minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 3,
				},
				[9] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
				["fuel"] = "1282",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
	},			
	["MiG-21Bis"] = {
		["Anti-ship Strike"] = {
			["Antiship IPW R-3R*1, R-3S*1, FT800L, S-24B*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3S}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{S-24B}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{S-24B}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
				["fuel"] = 2280,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Antiship Strike - R-3R*1, R-3S*1, FT800L, FAB-500*2"] = {
				minscore = 0.3,
				support = {
					["Escort"] = true,
					["SEAD"] = false,
					["Laser Illumination"] = false,					
				},
				attributes = {"ship"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 5000,
				hAttack = 5000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
					["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3S}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},	
		},
		["Intercept"] = {
			["IPW R-3R*2, R-3S*2, FT800L"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 600000,
				capability = 5,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-3S}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-3S}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["IPW R-3R*2, R-3S*2, FT800L"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 600000,
				capability = 5,
				firepower = 1,
				vCruise = 200,
				vAttack = 220,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = 1800,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-3S}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-3S}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},	
		["Escort"] = {
			["IPW R-3R*2, R-3S*2, FT800L"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 5,
				firepower = 1,
				vCruise = 200,
				-- vAttack = 350,
				-- hCruise = 7500,
				-- hAttack = 5500,
				standoff = 10000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-3S}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-3S}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
		["Fighter Sweep"] = {
			["IPW R-3R*2, R-3S*2, FT800L"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 5,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 7500,
				hAttack = 5500,
				standoff = 20000,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[4] = {
					["CLSID"] = "{R-3S}",
					["num"] = 4,
				},
				[2] = {
					["CLSID"] = "{R-3S}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["IPW - Strike - R-3R*1, R-3S*1, FT800L, FAB-250*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{R-3S}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{R-3R}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
			-- ["IPW - Strike - R-3R*1, R-3S*1, FT800L, FAB-100*8"] = {
				-- minscore = 0.3,
				-- support = {
						-- ["Escort"] = true,
						-- ["SEAD"] = false,
					-- },
				-- attributes = {"soft", "Parked Aircraft"},
				-- weaponType = "Bombs",
				-- expend = "All",
				-- attackType = "Dive",
				-- day = true,
				-- night = false,
				-- adverseWeather = false,
				-- range = 300000,
				-- capability = 1,
				-- firepower = 1,
				-- vCruise = 250,
				-- vAttack = 300,
				-- hCruise = 5500,
				-- hAttack = 4000,
				-- standoff = nil,
				-- tStation = nil,
				-- LDSD = false,
				-- self_escort = false,
				-- sortie_rate = 6,
				-- stores = {
				-- ["pylons"] = {
				-- [5] = {
					-- ["CLSID"] = "{FAB-100-4}",
					-- ["num"] = 5,
				-- },
				-- [2] = {
					-- ["CLSID"] = "{R-3S}",
					-- ["num"] = 2,
				-- },
				-- [4] = {
					-- ["CLSID"] = "{R-3R}",
					-- ["num"] = 4,
				-- },
				-- [1] = {
					-- ["CLSID"] = "{FAB-100-4}",
					-- ["num"] = 1,
				-- },
				-- [3] = {
					-- ["CLSID"] = "{PTB_800_MIG21}",
					-- ["num"] = 3,
				-- },
			-- }, -- end of ["pylons"]
                -- ["fuel"] = 2280,
					-- ["flare"] = 0,
					-- ["chaff"] = 0,
					-- ["gun"] = 100,
				-- },
			-- },
			["IPW - Strike - R-3R*1, R-3S*1, FT800L, FAB-500*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3S}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
			["IPW - Strike - R-3R*1, R-3S*1, FT800L, UB16UM*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 1500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3S}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{UB-16_S5M}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{UB-16_S5M}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
			["IPW - Strike - R-3R*1, R-3S*1, FT800L, S-24B*2"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Rockets",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 250,
				hCruise = 1500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3S}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{S-24B}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{S-24B}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},		
	},	
	["Su-17M4"] = {
		["Anti-ship Strike"] = {
			["IPW - AntishipStrike - FAB 500 M62*4"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"ship"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 280,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
			},
			},
		},	
		["Strike"] = {
			["IPW - Strike - FAB 500 M62*4"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 280,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Strike - FAB 250*16"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 280,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{3E35F8C1-052D-11d6-9191-00A0249B6F00}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Strike - RBK-500 PTAB-10-5*4"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 280,
				hCruise = 5500,
				hAttack = 4000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Strike - S-13*25"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 280,
				hCruise = 1500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["IPW - Strike - S-24B*4"] = {
				minscore = 0.3,
				support = {
						["Escort"] = true,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 1,
				firepower = 1,
				vCruise = 200,
				vAttack = 280,
				hCruise = 1500,
				hAttack = 1000,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",
					["num"] = 8,
				},
				[1] = {
					["CLSID"] = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}",
					["num"] = 3,
				},
				}, -- end of ["pylons"]
                ["fuel"] = "3770",
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},		
	},		
}
	